define("tiny_aiplacement/textmark",["exports"],(function(_exports){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0;
/**
   * Tiny AI Mark Changed text.
   *
   * This module marks text that was returned by the AI service
   * and that has been changed by a human prior to being inserted.
   *
   * @module      tiny_aiplacement/textmark
   * @copyright   2023 Matt Porritt <matt.porritt@moodle.com>
   * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */
class TinyAiTextMarker{static longestCommonSubsequence(a,b){const lengths=Array(a.length+1).fill(null).map((()=>Array(b.length+1).fill(0)));for(let i=0;i<a.length;i++)for(let j=0;j<b.length;j++)a[i]===b[j]?lengths[i+1][j+1]=lengths[i][j]+1:lengths[i+1][j+1]=Math.max(lengths[i+1][j],lengths[i][j+1]);let i=a.length,j=b.length,lcs="";for(;i>0&&j>0;)a[i-1]===b[j-1]?(lcs=a[i-1]+lcs,i--,j--):lengths[i-1][j]>lengths[i][j-1]?i--:j--;return lcs}static findDifferences(originalText,editedText){const lcs=TinyAiTextMarker.longestCommonSubsequence(originalText,editedText);let differences=[],i=0,j=0;for(let k=0;k<lcs.length;k++){let commonChar=lcs[k];for(;originalText[i]!==commonChar||editedText[j]!==commonChar;){let start=j;for(;editedText[j]!==commonChar;)j++;let editedSection=editedText.slice(start,j);for(differences.push({start:start,end:j,text:editedSection});originalText[i]!==commonChar;)i++}i++,j++}return j<editedText.length&&differences.push({start:j,end:editedText.length,text:editedText.slice(j)}),differences}static async wrapInSpan(editedSection){return new Promise(((resolve,reject)=>{try{resolve('<span class="user-edited">'.concat(editedSection,"</span>"))}catch(error){reject(error)}}))}static async wrapEditedSections(originalText,editedText){let differences=TinyAiTextMarker.findDifferences(originalText,editedText),wrappedText=editedText;for(let i=differences.length-1;i>=0;i--){let{start:start,end:end,text:text}=differences[i],wrappedSection=await TinyAiTextMarker.wrapInSpan(text);wrappedText=wrappedText.slice(0,start)+wrappedSection+wrappedText.slice(end)}return wrappedText}}return _exports.default=TinyAiTextMarker,_exports.default}));

//# sourceMappingURL=textmark.min.js.map